import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:six_pos/common/widgets/custom_menu_textfield_widget.dart';
import 'package:six_pos/features/product/controllers/product_controller.dart';
import 'package:six_pos/features/user/controllers/supplier_controller.dart';
import 'package:six_pos/features/user/domain/models/supplier_model.dart';
import 'package:six_pos/helper/responsive_helper.dart';
import 'package:six_pos/util/dimensions.dart';
import 'package:six_pos/util/styles.dart';
import 'package:six_pos/common/widgets/custom_text_field_widget.dart';
import 'package:six_pos/common/widgets/custom_field_with_title_widget.dart';


class ProductPriceInfoWidget extends StatefulWidget {
  const ProductPriceInfoWidget({Key? key}) : super(key: key);

  @override
  State<ProductPriceInfoWidget> createState() => _ProductPriceInfoWidgetState();
}

class _ProductPriceInfoWidgetState extends State<ProductPriceInfoWidget> {

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ProductController>(
        builder: (productController) {
          return SingleChildScrollView(
            child: Column(crossAxisAlignment: CrossAxisAlignment.start,children: [

              Padding(
                padding: const EdgeInsets.all(Dimensions.paddingSizeLarge).copyWith(top: 0),
                child: Text('price_setup'.tr, style: ubuntuMedium.copyWith(fontSize: Dimensions.fontSizeDefault)),
              ),

              Container(
                padding: const EdgeInsets.all(Dimensions.paddingSizeLarge),
                color: Theme.of(context).cardColor,
                child: Container(
                  padding: EdgeInsets.all(Dimensions.fontSizeSmall),
                  decoration: BoxDecoration(
                    color: Theme.of(context).hintColor.withValues(alpha: 0.08),
                    borderRadius: BorderRadius.circular(Dimensions.paddingSizeExtraSmall),
                  ),
                  child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                      if(ResponsiveHelper.isTab(context))...[
                        Row(children: [
                          Expanded(
                            child: CustomFieldWithTitleWidget(
                              customTextField: CustomTextFieldWidget(hintText: 'selling_price_hint'.tr,
                                fontSize: Dimensions.fontSizeSmall,
                                controller: productController.productSellingPriceController,
                                inputType: TextInputType.number,
                                contentPadding: Dimensions.paddingSizeDefault,
                              ),
                              title: 'selling_price'.tr,
                              requiredField: true,
                              padding: 0,
                            ),
                          ),
                          SizedBox(width: Dimensions.paddingSizeLarge),

                          Expanded(
                            child: CustomFieldWithTitleWidget(
                              customTextField: CustomTextFieldWidget(hintText: 'purchase_price_hint'.tr,
                                controller: productController.productPurchasePriceController,
                                fontSize: Dimensions.fontSizeSmall,
                                inputType: TextInputType.number,
                                contentPadding: Dimensions.paddingSizeDefault,
                              ),
                              title: 'purchase_price'.tr,
                              requiredField: true,
                              padding: 0,
                            ),
                          ),
                          SizedBox(width: Dimensions.paddingSizeLarge),

                          Expanded(
                            child: CustomFieldWithTitleWidget(
                              customTextField: CustomMenuTextFieldWidget(hintText: 'amount'.tr,
                                fontSize: Dimensions.fontSizeSmall,
                                controller: productController.productDiscountController,
                                inputType: TextInputType.number,
                                menuWidget: Container(
                                  padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeSmall),
                                  height: 50, width: Get.width * 0.13,
                                  decoration: BoxDecoration(
                                      borderRadius: const BorderRadius.only(
                                        topRight: Radius.circular(8),
                                        bottomRight: Radius.circular(8),
                                      ),
                                      color: Theme.of(context).hintColor.withValues(alpha:0.15)
                                  ),
                                  child: DropdownButton<String>(
                                    value: productController.discountTypeIndex == 0 ? 'percent' : 'amount',
                                    items: <String>['percent', 'amount'].map((String value) {
                                      return DropdownMenuItem<String>(
                                        value: value,
                                        child: Text(value.tr, style: ubuntuRegular.copyWith(fontSize: Dimensions.fontSizeSmall)),
                                      );
                                    }).toList(),
                                    onChanged: (value) {
                                      productController.setSelectedDiscountType(value);
                                      productController.setDiscountTypeIndex(value == 'percent' ? 0 : 1, true);
                                    },
                                    isExpanded: true,
                                    underline: const SizedBox(),
                                    iconEnabledColor: Theme.of(context).hintColor,
                                  ),
                                ),
                              ),
                              title: 'discount_type'.tr,
                              padding: 0,
                            ),
                          ),
                        ])
                      ]
                      else...[
                        CustomFieldWithTitleWidget(
                          customTextField: CustomTextFieldWidget(hintText: 'selling_price_hint'.tr,
                            fontSize: Dimensions.fontSizeSmall,
                            controller: productController.productSellingPriceController,
                            inputType: TextInputType.number,
                            contentPadding: Dimensions.paddingSizeDefault,
                          ),
                          title: 'selling_price'.tr,
                          requiredField: true,
                          padding: 0,
                        ),
                        SizedBox(height: Dimensions.paddingSizeLarge),

                        CustomFieldWithTitleWidget(
                          customTextField: CustomTextFieldWidget(hintText: 'purchase_price_hint'.tr,
                            controller: productController.productPurchasePriceController,
                            fontSize: Dimensions.fontSizeSmall,
                            inputType: TextInputType.number,
                            contentPadding: Dimensions.paddingSizeDefault,
                          ),
                          title: 'purchase_price'.tr,
                          requiredField: true,
                          padding: 0,
                        ),
                        SizedBox(height: Dimensions.paddingSizeLarge),

                        CustomFieldWithTitleWidget(
                          customTextField: CustomMenuTextFieldWidget(hintText: 'amount'.tr,
                            fontSize: Dimensions.fontSizeSmall,
                            controller: productController.productDiscountController,
                            inputType: TextInputType.number,
                            menuWidget: Container(
                              padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeSmall),
                              height: 50,
                              decoration: BoxDecoration(
                                  borderRadius: const BorderRadius.only(
                                    topRight: Radius.circular(8),
                                    bottomRight: Radius.circular(8),
                                  ),
                                  color: Theme.of(context).hintColor.withValues(alpha:0.15)
                              ),
                              child: DropdownButton<String>(
                                value: productController.discountTypeIndex == 0 ? 'percent' : 'amount',
                                items: <String>['percent', 'amount'].map((String value) {
                                  return DropdownMenuItem<String>(
                                    value: value,
                                    child: Text(value.tr, style: ubuntuRegular.copyWith(fontSize: Dimensions.fontSizeSmall)),
                                  );
                                }).toList(),
                                onChanged: (value) {
                                  productController.setSelectedDiscountType(value);
                                  productController.setDiscountTypeIndex(value == 'percent' ? 0 : 1, true);
                                },
                                isExpanded: true,
                                underline: const SizedBox(),
                                iconEnabledColor: Theme.of(context).hintColor,
                              ),
                            ),
                          ),
                          title: 'discount_type'.tr,
                          padding: 0,
                        ),
                      ],
                      SizedBox(height: Dimensions.paddingSizeLarge),

                      if(ResponsiveHelper.isTab(context))...[
                        IntrinsicHeight(
                          child: Row(children: [
                            Expanded(
                              child: CustomFieldWithTitleWidget(
                                customTextField: CustomTextFieldWidget(hintText: 'tax_hint'.tr,
                                  fontSize: Dimensions.fontSizeSmall,
                                  controller: productController.productTaxController,
                                  inputType: TextInputType.number,
                                  contentPadding: Dimensions.paddingSizeDefault,
                                ),
                                title: '${'tax_in_percent'.tr}  (%)',
                                padding: 0,
                              ),
                            ),
                            SizedBox(width: Dimensions.paddingSizeLarge),
                          
                            Expanded(
                              child: GetBuilder<SupplierController>(builder: (supplierController) {
                                return Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                                  Text('supplier'.tr, style: ubuntuRegular.copyWith(fontSize: Dimensions.fontSizeSmall)),
                                  const SizedBox(height: Dimensions.paddingSizeSmall),
                          
                                  Container(
                                    height: 50,
                                    padding: const EdgeInsets.symmetric(horizontal:Dimensions.paddingSizeSmall),
                                    decoration: BoxDecoration(color: Theme.of(context).cardColor,
                                        border: Border.all(width: .5, color: Theme.of(context).hintColor.withValues(alpha:.7)),
                                        borderRadius: BorderRadius.circular(Dimensions.paddingSizeMediumBorder)),
                                    child: DropdownButton<int>(
                                      hint: Text('select_supplier'.tr, style: ubuntuRegular.copyWith(
                                        fontSize: Dimensions.fontSizeSmall,
                                        color: Theme.of(context).textTheme.bodyLarge?.color,
                                      )),
                                      value: supplierController.selectedSupplierId,
                                      items: supplierController.supplierModel?.supplierList?.map((Suppliers? value) {
                                        return DropdownMenuItem<int>(
                                            value: value?.id,
                                            child: Text(value?.name ?? '', style: ubuntuRegular.copyWith(fontSize: Dimensions.fontSizeSmall)));
                                      }).toList(),
                                      onChanged: (int? value) {
                                        supplierController.setSupplierIndex(value, true);
                                      },
                                      isExpanded: true,
                                      underline: const SizedBox(),
                                      iconEnabledColor: Theme.of(context).hintColor,
                                    ),
                                  ),
                                  const SizedBox(height: Dimensions.paddingSizeSmall),
                                ]);
                              }),
                            ),
                            SizedBox(width: Dimensions.paddingSizeLarge),
                            
                            Expanded(child: const SizedBox())
                          ]),
                        )
                      ]
                      else...[
                        CustomFieldWithTitleWidget(
                          customTextField: CustomTextFieldWidget(hintText: 'tax_hint'.tr,
                            fontSize: Dimensions.fontSizeSmall,
                            controller: productController.productTaxController,
                            inputType: TextInputType.number,
                            contentPadding: Dimensions.paddingSizeDefault,
                          ),
                          title: '${'tax_in_percent'.tr}  (%)',
                          padding: 0,
                        ),
                        SizedBox(height: Dimensions.paddingSizeLarge),

                        GetBuilder<SupplierController>(builder: (supplierController) {
                          return Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                            Text('supplier'.tr, style: ubuntuRegular.copyWith(fontSize: Dimensions.fontSizeSmall)),
                            const SizedBox(height: Dimensions.paddingSizeSmall),

                            Container(
                              height: 50,
                              padding: const EdgeInsets.symmetric(horizontal:Dimensions.paddingSizeSmall),
                              decoration: BoxDecoration(color: Theme.of(context).cardColor,
                                  border: Border.all(width: .5, color: Theme.of(context).hintColor.withValues(alpha:.7)),
                                  borderRadius: BorderRadius.circular(Dimensions.paddingSizeMediumBorder)),
                              child: DropdownButton<int>(
                                hint: Text('select_supplier'.tr, style: ubuntuRegular.copyWith(
                                  fontSize: Dimensions.fontSizeSmall,
                                  color: Theme.of(context).textTheme.bodyLarge?.color,
                                )),
                                value: supplierController.selectedSupplierId,
                                items: supplierController.supplierModel?.supplierList?.map((Suppliers? value) {
                                  return DropdownMenuItem<int>(
                                      value: value?.id,
                                      child: Text(value?.name ?? '', style: ubuntuRegular.copyWith(fontSize: Dimensions.fontSizeSmall)));
                                }).toList(),
                                onChanged: (int? value) {
                                  supplierController.setSupplierIndex(value, true);
                                },
                                isExpanded: true,
                                underline: const SizedBox(),
                                iconEnabledColor: Theme.of(context).hintColor,
                              ),
                            ),
                            const SizedBox(height: Dimensions.paddingSizeSmall),
                          ]);
                        })
                      ],
                  ]),
                ),
              ),
            ]),
          );
        }
    );
  }
}
